clear all
set more off
set mem 400m

* Final Version

log using "C:\Users\tnh158\Dropbox\interstates to mike\hotels final.log", replace

use "C:\Users\tnh158\Dropbox\interstates to mike\masterData.dta", clear

keep if year>=64

sort stcty year
by stcty year: gen dummy =1 if _N==1
keep if dummy==1

replace emp_t=. if emp_t==0

g stctyrte2=stcty*100+rte

sort stctyrte2 year

* clean up size distribution variables

replace s2_hot = 0 if s2_hot==.
replace s3_hot = 0 if s3_hot==.
replace s4_hot = 0 if s4_hot==.
replace s5_hot = 0 if s5_hot==.
replace s6_hot = 0 if s6_hot==.
replace s7_hot = 0 if s7_hot==.
replace s8_hot = 0 if s8_hot==.
replace s9_hot = 0 if s9_hot==.

g sx_hot = s4_hot + s5_hot + s6_hot + s7_hot + s8_hot + s9_hot

replace s2_edp = 0 if s2_edp==.
replace s3_edp = 0 if s3_edp==.
replace s4_edp = 0 if s4_edp==.
replace s5_edp = 0 if s5_edp==.
replace s6_edp = 0 if s6_edp==.
replace s7_edp = 0 if s7_edp==.
replace s8_edp = 0 if s8_edp==.
replace s9_edp = 0 if s9_edp==.

g sx_edp = s4_edp + s5_edp + s6_edp + s7_edp + s8_edp + s9_edp

replace s2_gas = 0 if s2_gas==.
replace s3_gas = 0 if s3_gas==.
replace s4_gas = 0 if s4_gas==.
replace s5_gas = 0 if s5_gas==.
replace s6_gas = 0 if s6_gas==.
replace s7_gas = 0 if s7_gas==.
replace s8_gas = 0 if s8_gas==.
replace s9_gas = 0 if s9_gas==.

g sx_gas = s4_gas + s5_gas + s6_gas + s7_gas + s8_gas + s9_gas


tsset stctyrte2 year

* generate the "balanced panel" indicator

replace est_hot=. if est_hot==0
by stctyrte2, sort: egen cestg = count(est_hot)


keep if cestg==29


* merge in county temperature data

merge m:1 stcty using "C:\Users\tnh158\Dropbox\interstates to mike\countytemp.dta"
keep if _merge==3
drop _merge

g atemp = (amaxtemp+amintemp)/2


g lemp_t = ln(emp_t)

* employees per 1000 employment

g emp1k_gas = emp_gas/emp_t*1000
g emp1k_edp = emp_edp/emp_t*1000
g emp1k_hot = emp_hot/emp_t*1000

g lemp_hot = ln(emp_hot)
g lemp_edp = ln(emp_edp)
g lemp_gas = ln(emp_gas)

* establishments per 1000 employment

g estpe_hot = est_hot/emp_t*1000
g estpe_edp = est_edp/emp_t*1000
g estpe_gas = est_gas/emp_t*1000

g lestpe_hot = ln(estpe_hot)
g lestpe_edp = ln(estpe_edp)
g lestpe_gas = ln(estpe_gas)

g lest_hot = ln(est_hot)
g lest_edp = ln(est_edp)
g lest_gas = ln(est_gas)


* employees per establishment

g empest_hot = emp_hot/est_hot
g empest_edp = emp_edp/est_edp
g empest_gas = emp_gas/est_gas

g lempest_hot = ln(empest_hot)
g lempest_edp = ln(empest_edp)
g lempest_gas = ln(empest_gas)

sort stctyrte2 year

g pre74=1 if year<1974
replace pre74=0 if year>=1974

g mid=1 if year==1973
replace mid=0 if year~=1973

g lestpe_hotm = lestpe_hot*mid
g lempest_hotm = lempest_hot*mid
g lest_hotm = lest_hot*mid

g lestpe_edpm = lestpe_edp*mid
g lempest_edpm = lempest_edp*mid
g lest_edpm = lest_edp*mid

g lestpe_gasm = lestpe_gas*mid
g lempest_gasm = lempest_gas*mid
g lest_gasm = lest_gas*mid

g s1_hotm = s1_hot*mid
g s2_hotm = s2_hot*mid
g s3_hotm = s3_hot*mid
g sx_hotm = sx_hot*mid

g s1_edpm = s1_edp*mid
g s2_edpm = s2_edp*mid
g s3_edpm = s3_edp*mid
g sx_edpm = sx_edp*mid

g s1_gasm = s1_gas*mid
g s2_gasm = s2_gas*mid
g s3_gasm = s3_gas*mid
g sx_gasm = sx_gas*mid


* cumulative share of miles in the corridor

g ccsmi =  CumulativeMilesCorridor/ TotalMilesCorridor

* create variables that identify years when construction took place in county

g cdummy=0
replace cdummy=1 if mi>0

* create variables that create separate cases according to whether construction has
* taken place in the county, and if so whether it is complete

* case x is when miles were completed in the county

g ccsmix=0
replace ccsmix=ccsmi if cdummy==1

* case 1 is when none of the highway has been completed in the county

g ccsmi1=0
replace ccsmi1=ccsmi if csmi==0&cdummy==0

* case 2 is when some of the highway has been completed in the county

g ccsmi2=0
replace ccsmi2=ccsmi if csmi>0&csmi<1&cdummy==0

* case 3 is when all of the highway has been completed in the county

g ccsmi3=0
replace ccsmi3=ccsmi if csmi==1&cdummy==0

* rename temp variable

g temp = atemp 

summarize temp

* temperature interactions

g ccsmit = ccsmi*(temp-55)
g csmit = csmi*(temp-55)


set matsize 400

*	TABLE 2

xi: xtreg lemp_hot L.lemp_hot i.year ccsmi, fe
xi: xtreg lemp_hot L.lemp_hot i.year ccsmi csmi, fe
xi: xtreg lemp_hot L.lemp_hot i.year ccsmix ccsmi1 ccsmi2 ccsmi3, fe

*	TABLE 3

xi: xtreg lestpe_hot L.lestpe_hot L.lempest_hot lestpe_hotm lempest_hotm  i.year ccsmi, fe
xi: xtreg lestpe_hot L.lestpe_hot L.lempest_hot lestpe_hotm lempest_hotm  i.year ccsmi csmi, fe
xi: xtreg lestpe_hot L.lestpe_hot L.lempest_hot lestpe_hotm lempest_hotm  i.year ccsmix ccsmi1 ccsmi2 ccsmi3, fe

xi: xtreg lempest_hot L.lestpe_hot L.lempest_hot lestpe_hotm lempest_hotm  i.year ccsmi, fe
xi: xtreg lempest_hot L.lestpe_hot L.lempest_hot lestpe_hotm lempest_hotm  i.year ccsmi csmi, fe
xi: xtreg lempest_hot L.lestpe_hot L.lempest_hot lestpe_hotm lempest_hotm  i.year ccsmix ccsmi1 ccsmi2 ccsmi3, fe

*	TABLE 4

xi: xtreg s1_hot L.s1_hot L.s2_hot L.s3_hot L.sx_hot L.s1_hotm L.s2_hotm L.s3_hotm L.sx_hotm  ccsmi i.year , fe
xi: xtreg s2_hot L.s1_hot L.s2_hot L.s3_hot L.sx_hot L.s1_hotm L.s2_hotm L.s3_hotm L.sx_hotm  ccsmi i.year , fe
xi: xtreg s3_hot L.s1_hot L.s2_hot L.s3_hot L.sx_hot L.s1_hotm L.s2_hotm L.s3_hotm L.sx_hotm  ccsmi i.year , fe
xi: xtreg sx_hot L.s1_hot L.s2_hot L.s3_hot L.sx_hot L.s1_hotm L.s2_hotm L.s3_hotm L.sx_hotm  ccsmi i.year , fe

xi: xtreg s1_hot L.s1_hot L.s2_hot L.s3_hot L.sx_hot L.s1_hotm L.s2_hotm L.s3_hotm L.sx_hotm  ccsmix ccsmi1 ccsmi2 ccsmi3 i.year , fe
xi: xtreg s2_hot L.s1_hot L.s2_hot L.s3_hot L.sx_hot L.s1_hotm L.s2_hotm L.s3_hotm L.sx_hotm  ccsmix ccsmi1 ccsmi2 ccsmi3 i.year , fe
xi: xtreg s3_hot L.s1_hot L.s2_hot L.s3_hot L.sx_hot L.s1_hotm L.s2_hotm L.s3_hotm L.sx_hotm  ccsmix ccsmi1 ccsmi2 ccsmi3 i.year , fe
xi: xtreg sx_hot L.s1_hot L.s2_hot L.s3_hot L.sx_hot L.s1_hotm L.s2_hotm L.s3_hotm L.sx_hotm  ccsmix ccsmi1 ccsmi2 ccsmi3 i.year , fe

* 	TABLE 5

xi: xtreg lemp_hot L.lemp_hot i.year ccsmi ccsmit, fe
xi: xtreg lestpe_hot L.lestpe_hot L.lempest_hot lestpe_hotm lempest_hotm i.year ccsmi ccsmit, fe
xi: xtreg lempest_hot L.lestpe_hot L.lempest_hot lestpe_hotm lempest_hotm i.year ccsmi ccsmit, fe

xi: xtreg s1_hot L.s1_hot L.s2_hot L.s3_hot L.sx_hot L.s1_hotm L.s2_hotm L.s3_hotm L.sx_hotm ccsmi ccsmit i.year , fe
xi: xtreg s2_hot L.s1_hot L.s2_hot L.s3_hot L.sx_hot L.s1_hotm L.s2_hotm L.s3_hotm L.sx_hotm ccsmi ccsmit i.year , fe
xi: xtreg s3_hot L.s1_hot L.s2_hot L.s3_hot L.sx_hot L.s1_hotm L.s2_hotm L.s3_hotm L.sx_hotm ccsmi ccsmit i.year , fe
xi: xtreg sx_hot L.s1_hot L.s2_hot L.s3_hot L.sx_hot L.s1_hotm L.s2_hotm L.s3_hotm L.sx_hotm ccsmi ccsmit i.year , fe

* 	TABLE 6

xi: xtreg lemp_edp L.lemp_edp i.year ccsmi ccsmit, fe
xi: xtreg lestpe_edp L.lestpe_edp L.lempest_edp lestpe_edpm lempest_edpm i.year ccsmi ccsmit, fe
xi: xtreg lempest_edp L.lestpe_edp L.lempest_edp lestpe_edpm lempest_edpm i.year ccsmi ccsmit, fe

xi: xtreg s1_edp L.s1_edp L.s2_edp L.s3_edp L.sx_edp L.s1_edpm L.s2_edpm L.s3_edpm L.sx_edpm ccsmi ccsmit i.year , fe
xi: xtreg s2_edp L.s1_edp L.s2_edp L.s3_edp L.sx_edp L.s1_edpm L.s2_edpm L.s3_edpm L.sx_edpm ccsmi ccsmit i.year , fe
xi: xtreg s3_edp L.s1_edp L.s2_edp L.s3_edp L.sx_edp L.s1_edpm L.s2_edpm L.s3_edpm L.sx_edpm ccsmi ccsmit i.year , fe
xi: xtreg sx_edp L.s1_edp L.s2_edp L.s3_edp L.sx_edp L.s1_edpm L.s2_edpm L.s3_edpm L.sx_edpm ccsmi ccsmit i.year , fe

* 	TABLE 7

xi: xtreg lemp_gas L.lemp_gas i.year ccsmi ccsmit, fe
xi: xtreg lestpe_gas L.lestpe_gas L.lempest_gas lestpe_gasm lempest_gasm i.year ccsmi ccsmit, fe
xi: xtreg lempest_gas L.lestpe_gas L.lempest_gas lestpe_gasm lempest_gasm i.year ccsmi ccsmit, fe

xi: xtreg s1_gas L.s1_gas L.s2_gas L.s3_gas L.sx_gas L.s1_gasm L.s2_gasm L.s3_gasm L.sx_gasm ccsmi ccsmit i.year , fe
xi: xtreg s2_gas L.s1_gas L.s2_gas L.s3_gas L.sx_gas L.s1_gasm L.s2_gasm L.s3_gasm L.sx_gasm ccsmi ccsmit i.year , fe
xi: xtreg s3_gas L.s1_gas L.s2_gas L.s3_gas L.sx_gas L.s1_gasm L.s2_gasm L.s3_gasm L.sx_gasm ccsmi ccsmit i.year , fe
xi: xtreg sx_gas L.s1_gas L.s2_gas L.s3_gas L.sx_gas L.s1_gasm L.s2_gasm L.s3_gasm L.sx_gasm ccsmi ccsmit i.year , fe



